/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_TEST_EvGv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue1 = new byte[2];
    byte[] sourceValue2 = new byte[2];
    byte[] tempResult = new byte[2];

    public Instruction_TEST_EvGv() {
    }

    public Instruction_TEST_EvGv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.cpu.flags[11] = false;
        this.cpu.flags[0] = false;
        this.cpu.flags[4] = false;
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceValue1 = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.sourceValue2 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue2 = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.tempResult[0] = (byte)(this.sourceValue1[0] & this.sourceValue2[0]);
        this.tempResult[1] = (byte)(this.sourceValue1[1] & this.sourceValue2[1]);
        this.cpu.flags[6] = this.tempResult[0] == 0 && this.tempResult[1] == 0;
        this.cpu.flags[7] = this.tempResult[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult[1]);
    }
}

